unit GameViewLightNode;

interface

uses Classes,
  CastleVectors, CastleUIControls, CastleControls, CastleKeysMouse,
  NyaRandomSwitch, X3DNodes;

type
  TViewLightNode = class(TCastleView)
  protected
    BabLight1S, BabLight2S, BabLight3S, BabLight4S: TSpotLightNode;
    BabLight1P, BabLight2P, BabLight3P, BabLight4P: TPointLightNode;
    procedure DoRandSwitch(const AEnable: Boolean);
    procedure DoBack(Sender: TObject);
  published
    RandomSwitch: TNyaRandomSwitch;
    ButtonBack: TCastleButton;
    LabelFps: TCastleLabel;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Start; override;
    procedure Update(const SecondsPassed: Single; var HandleInput: boolean); override;
  end;

var
  ViewLightNode: TViewLightNode;

implementation

uses
  CastleScene, GameViewMain;

constructor TViewLightNode.Create(AOwner: TComponent);
begin
  inherited;
  DesignUrl := 'castle-data:/gameviewlightnode.castle-user-interface';
end;

procedure TViewLightNode.Start;
begin
  inherited;

  { Bad Light }
  with (DesignedComponent('SceneMap') as TCastleScene) do
  begin
    BabLight1S:= Node(TSpotLightNode,  'BabLight1S') as TSpotLightNode;
    BabLight1P:= Node(TPointLightNode, 'BabLight1P') as TPointLightNode;
    BabLight2S:= Node(TSpotLightNode,  'BabLight2S') as TSpotLightNode;
    BabLight2P:= Node(TPointLightNode, 'BabLight2P') as TPointLightNode;
    BabLight3S:= Node(TSpotLightNode,  'BabLight3S') as TSpotLightNode;
    BabLight3P:= Node(TPointLightNode, 'BabLight3P') as TPointLightNode;
    BabLight4S:= Node(TSpotLightNode,  'BabLight4S') as TSpotLightNode;
    BabLight4P:= Node(TPointLightNode, 'BabLight4P') as TPointLightNode;
  end;

  RandomSwitch.OnSwitch:= {$ifdef FPC}@{$endif}DoRandSwitch;
  ButtonBack.OnClick:= {$ifdef FPC}@{$endif}DoBack;
end;

procedure TViewLightNode.Update(const SecondsPassed: Single; var HandleInput: boolean);
begin
  inherited;
  Assert(LabelFps <> nil, 'If you remove LabelFps from the design, remember to remove also the assignment "LabelFps.Caption := ..." from code');
  LabelFps.Caption := 'FPS: ' + Container.Fps.ToString;
end;

procedure TViewLightNode.DoRandSwitch(const AEnable: Boolean);
begin
  BabLight1S.IsOn:= AEnable;
  BabLight1P.IsOn:= AEnable;
  BabLight2S.IsOn:= AEnable;
  BabLight2P.IsOn:= AEnable;
  BabLight3S.IsOn:= AEnable;
  BabLight3P.IsOn:= AEnable;
  BabLight4S.IsOn:= AEnable;
  BabLight4P.IsOn:= AEnable;
end;

procedure TViewLightNode.DoBack(Sender: TObject);
begin
  Container.View:= ViewMain;
end;

end.
