unit GameViewCastleLight;

interface

uses Classes,
  CastleVectors, CastleUIControls, CastleControls, CastleKeysMouse,
  CastleScene, NyaRandomSwitch;

type
  TViewCastleLight = class(TCastleView)
  protected
    procedure DoRandSwitch(const AEnable: Boolean);
    procedure DoBack(Sender: TObject);
  published
    SpotLight2, SpotLight3, SpotLight4, SpotLight5: TCastleSpotLight;
    PointLight2, PointLight3, PointLight4, PointLight5: TCastlePointLight;
    RandomSwitch: TNyaRandomSwitch;
    ButtonBack: TCastleButton;
    LabelFps: TCastleLabel;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Start; override;
    procedure Update(const SecondsPassed: Single; var HandleInput: boolean); override;
  end;

var
  ViewCastleLight: TViewCastleLight;

implementation

uses
  GameViewMain;

constructor TViewCastleLight.Create(AOwner: TComponent);
begin
  inherited;
  DesignUrl := 'castle-data:/gameviewcastlelight.castle-user-interface';
end;

procedure TViewCastleLight.Start;
begin
  inherited;

  RandomSwitch.OnSwitch:= {$ifdef FPC}@{$endif}DoRandSwitch;
  ButtonBack.OnClick:= {$ifdef FPC}@{$endif}DoBack;
end;

procedure TViewCastleLight.Update(const SecondsPassed: Single; var HandleInput: boolean);
begin
  inherited;
  Assert(LabelFps <> nil, 'If you remove LabelFps from the design, remember to remove also the assignment "LabelFps.Caption := ..." from code');
  LabelFps.Caption := 'FPS: ' + Container.Fps.ToString;
end;

procedure TViewCastleLight.DoRandSwitch(const AEnable: Boolean);
begin
  SpotLight2.Exists:= AEnable;
  PointLight2.Exists:= AEnable;
  SpotLight3.Exists:= AEnable;
  PointLight3.Exists:= AEnable;
  SpotLight4.Exists:= AEnable;
  PointLight4.Exists:= AEnable;
  SpotLight5.Exists:= AEnable;
  PointLight5.Exists:= AEnable;
end;

procedure TViewCastleLight.DoBack(Sender: TObject);
begin
  Container.View:= ViewMain;
end;

end.
