{ Main view, where most of the application logic takes place.

  Feel free to use this code as a starting point for your own projects.
  This template code is in public domain, unlike most other CGE code which
  is covered by BSD or LGPL (see https://castle-engine.io/license). }
unit GameViewMain;

interface

uses Classes,
  CastleVectors, CastleComponentSerialize, CastleScene,
  CastleUIControls, CastleControls, CastleKeysMouse;

type
  { Main view, where most of the application logic takes place. }
  TViewMain = class(TCastleView)
  protected
    procedure ClickControl(Sender: TObject);
    procedure TransControl(Sender: TObject);
  published
    { Components designed using CGE editor.
      These fields will be automatically initialized at Start. }
    Chara: TCastleScene;
    ButtonWalk, ButtonWalkReverse, ButtonRun, ButtonJump, ButtonStop: TCastleButton;
    EditTrans: TCastleFloatEdit;
    LabelFps: TCastleLabel;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Start; override;
    procedure Update(const SecondsPassed: Single; var HandleInput: Boolean); override;
    function Press(const Event: TInputPressRelease): Boolean; override;
  end;

var
  ViewMain: TViewMain;

implementation

uses SysUtils;

{ TViewMain ----------------------------------------------------------------- }

constructor TViewMain.Create(AOwner: TComponent);
begin
  inherited;
  DesignUrl := 'castle-data:/gameviewmain.castle-user-interface';
end;

procedure TViewMain.Start;
begin
  inherited;

  Chara.DefaultAnimationTransition:= EditTrans.Value;

  { set Buttons }
  ButtonWalk.OnClick:= {$ifdef FPC}@{$endif}ClickControl;
  ButtonWalkReverse.OnClick:= {$ifdef FPC}@{$endif}ClickControl;
  ButtonRun.OnClick:= {$ifdef FPC}@{$endif}ClickControl;
  ButtonJump.OnClick:= {$ifdef FPC}@{$endif}ClickControl;
  ButtonStop.OnClick:= {$ifdef FPC}@{$endif}ClickControl;
  EditTrans.OnChange:= {$ifdef FPC}@{$endif}TransControl;
end;

procedure TViewMain.Update(const SecondsPassed: Single; var HandleInput: Boolean);
begin
  inherited;
  { This virtual method is executed every frame (many times per second). }
  Assert(LabelFps <> nil, 'If you remove LabelFps from the design, remember to remove also the assignment "LabelFps.Caption := ..." from code');
  LabelFps.Caption := 'FPS: ' + Container.Fps.ToString;
end;

function TViewMain.Press(const Event: TInputPressRelease): Boolean;
begin
  Result := inherited;
  if Result then Exit; // allow the ancestor to handle keys

  { This virtual method is executed when user presses
    a key, a mouse button, or touches a touch-screen.

    Note that each UI control has also events like OnPress and OnClick.
    These events can be used to handle the "press", if it should do something
    specific when used in that UI control.
    The TViewMain.Press method should be used to handle keys
    not handled in children controls.
  }

  // Use this to handle keys:
  {
  if Event.IsKey(keyXxx) then
  begin
    // DoSomething;
    Exit(true); // key was handled
  end;
  }
end;

procedure TViewMain.ClickControl(Sender: TObject);
var
  button: TCastleButton;
begin
  button:= Sender as TCastleButton;
  if NOT Assigned(button) then exit;

  Case button.Name of
    'ButtonWalk':
      Chara.PlayAnimation('walk', True, True);
    'ButtonWalkReverse':
      Chara.PlayAnimation('walk', True, False);
    'ButtonRun':
      Chara.PlayAnimation('run', True, True);
    'ButtonJump':
      Chara.PlayAnimation('jump', True, True);
    'ButtonStop':
      Chara.StopAnimation();
  end;
end;

procedure TViewMain.TransControl(Sender: TObject);
var
  edit: TCastleFloatEdit;
begin
  edit:= Sender as TCastleFloatEdit;
  if NOT Assigned(edit) then exit;

  Chara.DefaultAnimationTransition:= edit.Value;
end;

end.
